package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.JLabel;
import java.awt.Font;
import java.awt.Color;
import net.miginfocom.swing.MigLayout;
import javax.swing.JTextField;

public class MainAppWindow {

	private JFrame frmExpectingToFly;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel eastPanel;
	private JPanel southPanel;
	private JPanel centerPanel;
	private JButton btnNewButton;
	private JLabel label;
	private JTextField textField;
	private JButton btnNewButton_1;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmExpectingToFly.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmExpectingToFly = new JFrame();
		frmExpectingToFly.setTitle("Expecting to Fly");
		frmExpectingToFly.setBounds(100, 100, 687, 479);
		frmExpectingToFly.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmExpectingToFly.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmExpectingToFly.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmExpectingToFly.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmExpectingToFly.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmExpectingToFly.getContentPane().add(getCenterPanel(), BorderLayout.CENTER);
	}

	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
			northPanel.add(getBtnNewButton());
			northPanel.add(getLabel());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
		}
		return westPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
		}
		return eastPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
		}
		return southPanel;
	}
	private JPanel getCenterPanel() {
		if (centerPanel == null) {
			centerPanel = new JPanel();
			centerPanel.setLayout(new MigLayout("", "[][][][]", "[]"));
			centerPanel.add(getTextField(), "cell 0 0,growx");
			centerPanel.add(getBtnNewButton_1(), "cell 2 0 2 1");
		}
		return centerPanel;
	}
	private JButton getBtnNewButton() {
		if (btnNewButton == null) {
			btnNewButton = new JButton("Start");
		}
		return btnNewButton;
	}
	private JLabel getLabel() {
		if (label == null) {
			label = new JLabel("1966");
			label.setForeground(new Color(0, 153, 0));
			label.setFont(new Font("Tahoma", Font.BOLD, 16));
		}
		return label;
	}
	private JTextField getTextField() {
		if (textField == null) {
			textField = new JTextField();
			textField.setColumns(10);
		}
		return textField;
	}
	private JButton getBtnNewButton_1() {
		if (btnNewButton_1 == null) {
			btnNewButton_1 = new JButton("New button");
		}
		return btnNewButton_1;
	}
}
